﻿/* Skript zur Demonstration von Flashback
 * Als Benutzer SCOTT ausführen
 */
 
-- Zunächst prüfen wir, ob der Parameter korrekt eingestellt ist:
select value
  from v$parameter
 where name = 'undo_retention';
 
-- Daten werden geändert und festgeschrieben
update emp
   set deptno = 10;
   
commit;

-- Oops, where-Klausel vergessen:
select ename, job, deptno
  from emp;
  
--  daher schnell zurück zum alten Stand:
select ename, job, deptno
  from emp
    as of timestamp systimestamp - interval '10' minute;

-- das sind die richtigen Daten, aktualisieren:
update emp e
   set deptno = (select deptno
                   from emp
                     as of timestamp systimestamp - interval '10' minute
                  where empno = e.empno);

commit;

-- Kontrolle: Alles wieder im Lot
select ename, job, deptno
  from emp;


-- Flashback-Versions-Query
select ename, job, deptno,
       versions_operation, versions_xid, versions_starttime
  from emp
       versions between timestamp
       systimestamp - interval '20' minute
   and systimestamp
 where ename = 'SMITH'
 order by versions_starttime desc;